/*
 * Decompiled with CFR 0.152.
 */
package salesmansolver;

import com.google.maps.model.LatLng;

public class Gene {
    private final String name;
    private final double x;
    private final double y;

    public Gene(String name, double x, double y) {
        this.name = name;
        this.x = x;
        this.y = y;
    }

    public Gene(Gene g) {
        this.name = g.name;
        this.x = g.x;
        this.y = g.y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double distance(Gene other) {
        return this.airlineDistance(new LatLng(this.x, this.y), new LatLng(other.x, other.y));
    }

    public double airlineDistance(LatLng departue, LatLng arrival) {
        departue.lat = Math.toRadians(departue.lat);
        departue.lng = Math.toRadians(departue.lng);
        arrival.lat = Math.toRadians(arrival.lat);
        arrival.lng = Math.toRadians(arrival.lng);
        double dlng = arrival.lng - departue.lng;
        double dlat = arrival.lat - departue.lat;
        double a = Math.pow(Math.sin(dlat / 2.0), 2.0) + Math.cos(departue.lat) * Math.cos(arrival.lat) * Math.pow(Math.sin(dlng / 2.0), 2.0);
        double c = 2.0 * Math.asin(Math.sqrt(a));
        double r = 6371.0;
        return c * r;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Gene g = (Gene)o;
        return this.x == g.getX() && this.y == g.getY();
    }
}

